/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.simibubi.create.content.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class DynamicBrush
extends Brush {
    public static final int MAX_RADIUS = 10;
    private boolean surface;

    public DynamicBrush(boolean surface) {
        super(1);
        this.surface = surface;
    }

    @Override
    class_2561 getParamLabel(int paramIndex) {
        return Lang.translateDirect("generic.range", new Object[0]);
    }

    @Override
    public TerrainTools[] getSupportedTools() {
        TerrainTools[] terrainToolsArray;
        if (this.surface) {
            TerrainTools[] terrainToolsArray2 = new TerrainTools[3];
            terrainToolsArray2[0] = TerrainTools.Overlay;
            terrainToolsArray2[1] = TerrainTools.Replace;
            terrainToolsArray = terrainToolsArray2;
            terrainToolsArray2[2] = TerrainTools.Clear;
        } else {
            TerrainTools[] terrainToolsArray3 = new TerrainTools[2];
            terrainToolsArray3[0] = TerrainTools.Replace;
            terrainToolsArray = terrainToolsArray3;
            terrainToolsArray3[1] = TerrainTools.Clear;
        }
        return terrainToolsArray;
    }

    @Override
    public boolean hasPlacementOptions() {
        return false;
    }

    @Override
    public boolean hasConnectivityOptions() {
        return true;
    }

    @Override
    int getMax(int paramIndex) {
        return 10;
    }

    @Override
    int getMin(int paramIndex) {
        return 1;
    }

    @Override
    public TerrainTools redirectTool(TerrainTools tool) {
        if (tool == TerrainTools.Overlay) {
            return TerrainTools.Place;
        }
        return super.redirectTool(tool);
    }

    @Override
    public Collection<class_2338> addToGlobalPositions(class_1936 world, class_2338 targetPos, class_2350 targetFace, Collection<class_2338> affectedPositions, TerrainTools usedTool) {
        boolean searchDiagonals = this.param1 == 0;
        boolean fuzzy = this.param2 == 0;
        boolean replace = usedTool != TerrainTools.Overlay;
        int searchRange = this.param0;
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        class_2680 state = world.method_8320(targetPos);
        LinkedList<class_2338> offsets = new LinkedList<class_2338>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) >= 2 && !searchDiagonals || targetFace.method_10166().method_10173(x, y, z) != 0 && this.surface) continue;
                    offsets.add(new class_2338(x, y, z));
                }
            }
        }
        class_2338 startPos = replace ? targetPos : targetPos.method_10093(targetFace);
        frontier.add(startPos);
        while (!frontier.isEmpty()) {
            class_2338 currentPos = (class_2338)frontier.remove(0);
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!currentPos.method_19771((class_2382)startPos, (double)searchRange)) continue;
            if (replace) {
                class_2680 stateToReplace = world.method_8320(currentPos);
                class_2680 stateAboveStateToReplace = world.method_8320(currentPos.method_10093(targetFace));
                if (stateToReplace.method_26214((class_1922)world, currentPos) == -1.0f || stateToReplace.method_26204() != state.method_26204() && !fuzzy || stateToReplace.method_26207().method_15800() || BlockHelper.hasBlockSolidSide(stateAboveStateToReplace, (class_1922)world, currentPos.method_10093(targetFace), targetFace.method_10153()) && this.surface) continue;
                affectedPositions.add(currentPos);
                for (class_2338 offset : offsets) {
                    frontier.add(currentPos.method_10081((class_2382)offset));
                }
                continue;
            }
            class_2680 stateToPlaceAt = world.method_8320(currentPos);
            class_2680 stateToPlaceOn = world.method_8320(currentPos.method_10093(targetFace.method_10153()));
            if (stateToPlaceOn.method_26207().method_15800() || stateToPlaceOn.method_26204() != state.method_26204() && !fuzzy || !stateToPlaceAt.method_26207().method_15800()) continue;
            affectedPositions.add(currentPos);
            for (class_2338 offset : offsets) {
                frontier.add(currentPos.method_10081((class_2382)offset));
            }
        }
        return affectedPositions;
    }
}

